@extends('backend.master')
@section('title')
    {{ $title }}
@endsection
@section('content')
    <x-container title="{{ $title }}" :breadcrumbs="[['title' => 'Account'],['title' => $title]]">
        <div class="table-content table-basic mt-20">
            <div class="card">
                <div class="card-header py-3 d-flex justify-content-between align-items-center">
                    <div class="col-lg-2">
                        <h4 class="mb-0">{{ _trans('common.Generated Bills') }}</h4>
                    </div>
                    <div class="col-lg-10">
                        <form action="" class="row align-items-center ">
                            <x-forms.select name="property_id" col="col-lg-3">
                                <option value="">{{ _trans('common.Select Property') }}</option>
                                @foreach($properties as $property)
                                    <option value="{{ $property->id }}">{{ $property->name }}</option>
                                @endforeach
                            </x-forms.select>

                            <x-forms.select name="tenant_id" col="col-lg-3">
                                <option value="">{{ _trans('common.Select Tenant') }}</option>
                                @foreach($tenants as $tenant)
                                    <option value="{{ $tenant->id }}">{{ $tenant->name }}</option>
                                @endforeach
                            </x-forms.select>
                            <x-forms.input
                                col="col-lg-3"
                                type="month"
                                name="month"
                                value="{{ request('month') }}"
                            ></x-forms.input>
                            @if(request('property_id') || request('tenant_id') || request('month'))
                                <div class="col-lg-1">
                                    <a type="reset" href="{{ route('bill.index') }}" class="btn btn-danger">{{ _trans('common.Reset') }}</a>
                                </div>
                            @endif
                            <div class="col-lg-2">
                                <x-button title="Search" class="mt-0" icon="las la-search"></x-button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="card-body ot-card">
                    <div class="table-responsive">
                        <table class="table table-bordered ot-table-bg">
                            <thead class="thead">
                            <tr>
                                <th class="serial">{{ _trans('common.SR No') }}</th>
                                <th>{{ _trans('common.Property') }}</th>
                                <th>{{ _trans('common.Tenant') }}</th>
                                <th>{{ _trans('common.Due Date') }}</th>
                                <th>{{ _trans('common.Month of Bill') }}</th>
                                <th>{{ _trans('common.Amount') }}</th>
                                <th>{{ _trans('common.Fine Amount') }}</th>
                                <th>{{ _trans('common.Total Amount') }}</th>
                                <th>{{ _trans('common.Payment Status') }}</th>
                                <th>{{ _trans('common.Generated By') }}</th>
                                <th class="action">{{ _trans('common.Action') }}</th>
                            </tr>
                            </thead>
                            <tbody class="tbody">
                            @forelse($bills as $row)
                                <tr>
                                    <th>{{ $loop->iteration }}</th>
                                    <td>{{ @$row->property->name }}</td>
                                    <td>{{ @$row->tenant->name }}</td>
                                    <td>{{ $row->due_date }}</td>
                                    <td>{{ date('F Y', strtotime($row->month)) }}</td>
                                    <td>{{ $row->amount }}</td>
                                    <td>{{ $row->fine_amount }}</td>
                                    <td>{{ $row->total_amount }}</td>
                                    <td>
                                        <span class="badge text-capitalize bg-{{ $row->payment_status == 'paid' ? 'success':($row->payment_status == 'unpaid' ? 'warning': 'danger') }}">{{ $row->payment_status }}</span>
                                    </td>
                                    <td>{{ @$row->createdby->name }}</td>
                                    <td class="action">
                                        <x-action.dropdown>
                                            <x-action.button
                                                route="{{ route('bill.collect_bill', $row->id) }}"
                                                text="Collect Bill"
                                                icon="fa-solid fa-wallet">
                                            </x-action.button>
                                            <x-action.button
                                                text="Invoice"
                                                route="{{ route('bill.show', $row->id) }}"
                                                icon="fa-solid fa-print">
                                            </x-action.button>
                                        </x-action.dropdown>

                                    </td>
                                </tr>
                            @empty
                                <x-emptytable></x-emptytable>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                    <div class="ot-pagination pagination-content d-flex justify-content-end align-content-center py-3">
                        <nav aria-label="Page navigation example">
                            <ul class="pagination">
                                {!! $bills->links() !!}
                            </ul>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </x-container>

    <div class="modal fade" id="bill-collect-form" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{ route('bill.payment') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="staticBackdropLabel">{{ _trans('common.Collect Bill') }}</h1>
                    </div>
                    <div class="modal-body" id="collect-form-inputs">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">{{ _trans('common.Close') }}</button>
                        <button type="submit" class="btn btn-success">{{ _trans('common.Process to pay') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        $(document).ready(function () {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: '{{ route('bill.calculate_fine') }}',
                type: 'POST',
                success: function (response){

                },
                error: function (error) {
                    console.log(error)
                }
            })
        })
    </script>
    <script>
        @if ($errors->any())
        // If there are validation errors, display the modal
        $(document).ready(function () {
            $('#bill-collect-form').modal('show');
        });
        @endif
    </script>
    <script>

        const collectBill = (id) => {
            $.ajax({
                url: '{{ route('bill.bill_amount') }}',
                type: 'GET',
                data:{id},
                success: function (response) {
                    var modalBody = $('#collect-form-inputs');
                    modalBody.empty()
                    modalBody.append(`
                    <input type="hidden" name="bill_id" value="${id}">
                    <x-forms.input readonly :browserRequired="true" label="Total Amount" value="${response.total_amount}" col="col-lg-12 mb-3" type="number" name="total_amount"></x-forms.input>
                    <x-forms.input :browserRequired="true" label="Payment Amount" col="col-lg-12 mb-3" type="number" name="payment_amount"></x-forms.input>
                    <x-forms.file label="Attachment" name="attachment" col="col-lg-12 mb-3"></x-forms.file>
                    <x-forms.textarea label="Additional Info" name="additional_info"></x-forms.textarea>
                    `)

                    $('#bill-collect-form').modal('show');
                },
                error: function (error) {
                    console.error(error);
                }
            });
        }
    </script>

@endpush
