import { AxiosProgressEvent, AxiosResponse } from 'axios';
declare module 'axios' {
    interface AxiosProgressEvent {
        percentage: number | undefined;
    }
}
export type Errors = Record<string, string>;
export type ErrorBag = Record<string, Errors>;
export type FormDataConvertible = Array<FormDataConvertible> | {
    [key: string]: FormDataConvertible;
} | Blob | FormDataEntryValue | Date | boolean | number | null | undefined;
export type Method = 'get' | 'post' | 'put' | 'patch' | 'delete';
export type RequestPayload = Record<string, FormDataConvertible> | FormData;
export interface PageProps {
    [key: string]: unknown;
}
export interface Page<SharedProps extends PageProps = PageProps> {
    component: string;
    props: PageProps & SharedProps & {
        errors: Errors & ErrorBag;
    };
    url: string;
    version: string | null;
    /** @internal */
    scrollRegions: Array<{
        top: number;
        left: number;
    }>;
    /** @internal */
    rememberedState: Record<string, unknown>;
}
export type PageResolver = (name: string) => Component;
export type PageHandler = ({ component, page, preserveState, }: {
    component: Component;
    page: Page;
    preserveState: PreserveStateOption;
}) => Promise<unknown>;
export type PreserveStateOption = boolean | 'errors' | ((page: Page) => boolean);
export type Progress = AxiosProgressEvent;
export type LocationVisit = {
    preserveScroll: boolean;
};
export type Visit = {
    method: Method;
    data: RequestPayload;
    replace: boolean;
    preserveScroll: PreserveStateOption;
    preserveState: PreserveStateOption;
    only: Array<string>;
    except: Array<string>;
    headers: Record<string, string>;
    errorBag: string | null;
    forceFormData: boolean;
    queryStringArrayFormat: 'indices' | 'brackets';
};
export type GlobalEventsMap = {
    before: {
        parameters: [PendingVisit];
        details: {
            visit: PendingVisit;
        };
        result: boolean | void;
    };
    start: {
        parameters: [PendingVisit];
        details: {
            visit: PendingVisit;
        };
        result: void;
    };
    progress: {
        parameters: [Progress | undefined];
        details: {
            progress: Progress | undefined;
        };
        result: void;
    };
    finish: {
        parameters: [ActiveVisit];
        details: {
            visit: ActiveVisit;
        };
        result: void;
    };
    cancel: {
        parameters: [];
        details: {};
        result: void;
    };
    navigate: {
        parameters: [Page];
        details: {
            page: Page;
        };
        result: void;
    };
    success: {
        parameters: [Page];
        details: {
            page: Page;
        };
        result: void;
    };
    error: {
        parameters: [Errors];
        details: {
            errors: Errors;
        };
        result: void;
    };
    invalid: {
        parameters: [AxiosResponse];
        details: {
            response: AxiosResponse;
        };
        result: boolean | void;
    };
    exception: {
        parameters: [Error];
        details: {
            exception: Error;
        };
        result: boolean | void;
    };
};
export type GlobalEventNames = keyof GlobalEventsMap;
export type GlobalEvent<TEventName extends GlobalEventNames> = CustomEvent<GlobalEventDetails<TEventName>>;
export type GlobalEventParameters<TEventName extends GlobalEventNames> = GlobalEventsMap[TEventName]['parameters'];
export type GlobalEventResult<TEventName extends GlobalEventNames> = GlobalEventsMap[TEventName]['result'];
export type GlobalEventDetails<TEventName extends GlobalEventNames> = GlobalEventsMap[TEventName]['details'];
export type GlobalEventTrigger<TEventName extends GlobalEventNames> = (...params: GlobalEventParameters<TEventName>) => GlobalEventResult<TEventName>;
export type GlobalEventCallback<TEventName extends GlobalEventNames> = (...params: GlobalEventParameters<TEventName>) => GlobalEventResult<TEventName>;
export type VisitOptions = Partial<Visit & {
    onCancelToken: {
        ({ cancel }: {
            cancel: VoidFunction;
        }): void;
    };
    onBefore: GlobalEventCallback<'before'>;
    onStart: GlobalEventCallback<'start'>;
    onProgress: GlobalEventCallback<'progress'>;
    onFinish: GlobalEventCallback<'finish'>;
    onCancel: GlobalEventCallback<'cancel'>;
    onSuccess: GlobalEventCallback<'success'>;
    onError: GlobalEventCallback<'error'>;
}>;
export type PendingVisit = Visit & {
    url: URL;
    completed: boolean;
    cancelled: boolean;
    interrupted: boolean;
};
export type ActiveVisit = PendingVisit & Required<VisitOptions> & {
    cancelToken: AbortController;
};
export type VisitId = unknown;
export type Component = unknown;
export type InertiaAppResponse = Promise<{
    head: string[];
    body: string;
} | void>;
declare global {
    interface DocumentEventMap {
        'inertia:before': GlobalEvent<'before'>;
        'inertia:start': GlobalEvent<'start'>;
        'inertia:progress': GlobalEvent<'progress'>;
        'inertia:success': GlobalEvent<'success'>;
        'inertia:error': GlobalEvent<'error'>;
        'inertia:invalid': GlobalEvent<'invalid'>;
        'inertia:exception': GlobalEvent<'exception'>;
        'inertia:finish': GlobalEvent<'finish'>;
        'inertia:navigate': GlobalEvent<'navigate'>;
    }
}
