<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


class RoleSeeder extends Seeder
{
    public function run()
    {
        Role::create([
            'name' => 'Super Admin',
            'permissions' => [
                'user_read',
                'user_create',
                'user_update',
                'user_delete',
                'role_read',
                'role_create',
                'role_update',
                'role_delete',
                'language_read',
                'language_create',
                'language_update',
                'language_update_terms',
                'language_delete',
                'general_settings_read',
                'general_settings_update',
                'storage_settings_read',
                'storage_settings_update',
                'recaptcha_settings_read',
                'recaptcha_settings_update',
                'email_settings_read',
                'email_settings_update',
                'testimonial_read',
                'testimonial_create',
                'testimonial_update',
                'testimonial_delete',
                'blogs_read',
                'blogs_create',
                'blogs_update',
                'blogs_delete',
                'blog_categories_read',
                'blog_categories_create',
                'blog_categories_update',
                'blog_categories_delete',
                'category_read',
                'category_create',
                'category_update',
                'category_delete',
                'how-it-work_read',
                'how-it-work_create',
                'how-it-work_update',
                'how-it-work_delete',
                'business_model_create',
                'business_model_update',
                'business_model_delete',
                'section_titles_update',
                'partners_read',
                'partners_create',
                'partners_update',
                'partners_delete',
                'feature_read',
                'feature_create',
                'feature_update',
                'feature_delete',
                'hero_section_read',
                'hero_section_create',
                'hero_section_update',
                'hero_section_delete',
                'tenant_read',
                'tenant_create',
                'tenant_update',
                'tenant_delete',
                'property_read',
                'property_create',
                'property_update',
                'property_delete',
                'property_show',
                'contact_read',
                'contact_delete',
                'mail_subscribe_read',
                'mail_subscribe_delete',
                'about_update',
                'property_category_read',
                'property_category_create',
                'property_category_update',
                'property_category_delete',
                'property_facility_type_read',
                'property_facility_type_create',
                'property_facility_type_update',
                'property_facility_type_delete',
                'ad_action_permission',

                'committee_read',
                'committee_show',
                'committee_create',
                'committee_update',
                'committee_delete',

                'committee_member_read',
                'committee_member_create',
                'committee_member_delete',

                'db_backup_read',
                'db_backup_create',
                'db_backup_delete',

                'tenant_read',
                'tenant_create',
                'tenant_delete',
                'tenant_show',
                'rental_read',

                'tenant_report',
                'room_report',
                'payment_report',

                'order_read',
                'order_create',
                'order_delete',
                'order_show',
                'order_payment',

                'account_read',
                'account_create',
                'account_update',
                'account_delete',
                'account_show',

                'property_advertisement_read',
                'property_advertisement_update',
                'property_advertisement_delete',
                'property_advertisement_show',

                'account_category_read',
                'account_category_update',
                'account_category_delete',
                'account_category_show',

                'payment_read',
                'payment_create',
                'payment_update',
                'payment_delete',
                'payment_show',

                'income_read',
                'income_create',
                'income_update',
                'income_delete',
                'income_show',

                'expense_read',
                'expense_create',
                'expense_update',
                'expense_delete',
                'expense_show',

                'appointment_read',
                'appointment_create',
                'appointment_update',
                'appointment_delete',
                'appointment_show',

                'timeslot_read',
                'timeslot_create',
                'timeslot_update',
                'timeslot_delete',
                'timeslot_show',

                'profile_read',
                'profile_update',

                'mailbox_read',
                'mailbox_update',
                'mailbox_delete',
                'mailbox_show',

                'smsbox_read',
                'smsbox_create',
                'smsbox_update',
                'smsbox_delete',
                'smsbox_show',

                'bill_read',
                'bill_create',
                'bill_update',
                'bill_delete',
                'bill_show',
            ],
        ]);
        Role::create([
            'name' => 'Admin',
            'permissions' => [
                'user_read',
                'user_create',
                'user_update',
                'user_delete',
                'role_read',
                'role_create',
                'role_update',
                'role_delete',
                'language_read',
                'language_create',
                'language_update_terms',
                'general_settings_read',
                'general_settings_update',
                'storage_settings_read',
                'storage_settings_read',
                'recaptcha_settings_update',
                'email_settings_read',
                'testimonial_read',
                'testimonial_create',
                'testimonial_update',
                'testimonial_delete',
                'blogs_read',
                'blogs_create',
                'blogs_update',
                'blogs_delete',
                'blog_categories_read',
                'blog_categories_create',
                'blog_categories_update',
                'blog_categories_delete',
                'category_read',
                'category_create',
                'category_update',
                'category_delete',
                'how-it-work_read',
                'how-it-work_create',
                'how-it-work_update',
                'how-it-work_delete',
                'business_model_create',
                'business_model_update',
                'business_model_delete',
                'section_titles_update',
                'partners_read',
                'partners_create',
                'partners_update',
                'partners_delete',
                'feature_read',
                'feature_create',
                'feature_update',
                'feature_delete',
                'hero_section_read',
                'hero_section_create',
                'hero_section_update',
                'hero_section_delete',
                'tenant_read',
                'tenant_create',
                'tenant_update',
                'tenant_delete',
                'contact_read',
                'contact_delete',
                'mail_subscribe_read',
                'mail_subscribe_delete',
                'about_update',
                'property_category_read',
                'property_category_create',
                'property_category_update',
                'property_category_delete',
                'ad_action_permission'

            ],
        ]);
        Role::create([
            'name' => 'Land Owner',
            'permissions' => [
                'property_read',
                'property_create',
                'property_update',
                'property_delete',
            ],
        ]);
        Role::create([
            'name' => 'Land Lord',
            'permissions' => [
                'property_read',
                'property_create',
                'property_update',
                'property_delete',
            ],
        ]);
        Role::create([
            'name' => 'Tenant',
            'permissions' => [],
        ]);
        Role::create([
            'name' => 'Staff',
            'permissions' => [
                'user_read',
                'role_read',
                'language_read',
                'testimonial_read',
                'category_read',
                'how-it-work_read',
            ],
        ]);
    }
}
