<?php


namespace App\Http\Resources\Api\v1;


use Illuminate\Http\Resources\Json\ResourceCollection;

class TenantReportResouces extends ResourceCollection
{
    public function toArray($request)
    {
        $current_page = $this->currentPage();
        $total_pages = $this->lastPage();
        $base_url = \request()->url();

        return [
            'list' => $this->collection->map(function ($data) {
                return [
                    'id' => $data->id,
                    'name' => $data->order->tenant->name,
                    'email' => $data->order->tenant->email,
                    'property' => $data->property->name,
                    'for' => @$data->advertisement->advertisement_type == 1 ? 'Rent' : 'Sell',
                    'start_date' => $data->start_date,
                    'end_date' => isset($data->end_date) ? $data->end_date : 'Lifetime',
                    'status' => $data->status,
                ];
            }),
            'links' => [
                "first" => $base_url . "?page=1",
                "last" => $base_url . "?page=" . $total_pages,
                "prev" => $current_page > 1 ? $base_url . "?page=" . ($current_page - 1) : null,
                "next" => $current_page < $total_pages ? $base_url . "?page=" . ($current_page + 1) : null,
            ],
            'pagination' => [
                'total' => $this->total(),
                'count' => $this->count(),
                'per_page' => $this->perPage(),
                'current_page' => $this->currentPage(),
                'total_pages' => $this->lastPage(),
            ],
        ];
    }
}
