<?php



namespace App\Http\Requests\Blog;

use Illuminate\Foundation\Http\FormRequest;

class BlogStoreRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'title'             => 'required|unique:blogs,title',
            'category'          => 'required',
            'content'           => 'required',
            'image'             => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
            'status'            => 'required'
        ];
    }
}
?>
